/* 3次元的な表現 */
let st = ["おおた", "てらやま", "しらい", "なかの", "ごとう", "きたざき", "いしづか", "さいとう", "ふるかた"];
let x = new Array(st.length);   //文字のx座標を入れておく
let y = new Array(st.length);   //文字のy座標を入れておく
let z = new Array(st.length);   //文字のz座標を入れておく
let screenZ = 200;   //投影面のz座標
let vpX = 0;   //消失点のx, y座標
let vpY = 0;
function setup(){
  createCanvas(windowWidth, windowHeight);
  //文字の座標の初期化
  for(let i = 0; i < st.length; i = i + 1){
    x[i] = 0;
    y[i] = 0;
    z[i] = 200 + i * 100;
  }
}
function draw(){
  //消失点の位置を画面の中心に
  vpX = width/2;
  vpY = height/2;
  background(0);
  noStroke();
  textAlign(CENTER, CENTER);
  for(let i = 0; i < st.length; i = i + 1){    //stの数だけ繰り返し
    if(z[i] > -screenZ){    //計算エラー防止
      let scale = screenZ / (screenZ + z[i]);    //文字のz座標に応じた拡大率を計算
      let posX = vpX + x[i] * scale;    //拡大率に応じて、描画するx, y座標を求める
      let posY = vpY + y[i] * scale;
      let fSize = 100 * scale;      //拡大率に応じたフォントサイズの計算
      fill(0, 255, 0, 255 * scale);
      textSize(fSize);
      text(st[i], posX, posY);   //描画
    }
    z[i] -= 1;      //z座標を減らす（手前に移動させる）
  }
}
