/* 配列と繰り返しで円をたくさん描く+跳ね返り */
let x = new Array(500);   //円のx座標を入れる配列
let y = new Array(x.length);   //円のy座標を入れる配列。長さは配列xの長さと同じだけ
let addX = new Array(x.length);   //毎フレーム円に加えるx方向の速度
let addY = new Array(x.length);   //毎フレーム円に加えるy方向の速度

function setup(){
  createCanvas(windowWidth, windowHeight);
  //配列xの長さ（要素の数）ぶんだけ繰り返しを作り、各要素の値を初期化する
  for(let i = 0; i < x.length; i = i + 1){
      x[i] = width/2;  //i番目のxに、iに比例した値を代入する
      y[i] = height/2;   //i番目のyに、iに比例した値を代入する
      addX[i] = random(-5, 5);    //addXの初期化。-5から5までの間のランダムの値
      addY[i] = random(-5, 5);    //addYの初期化。
  }
}
function draw(){
  background(0);
  //配列xの長さぶんだけ繰り返しを作り、その回数だけ円を描く
  for(let i = 0; i < x.length; i = i + 1){
    fill(255, 255, 0, 100);
    noStroke();
    circle(x[i], y[i], 50); //x, yを使って円を描画
    x[i] = x[i] + addX[i];    //xにaddXを加える
    y[i] = y[i] + addY[i];    //yにaddYを加える
    //壁に跳ね返る
    if(x[i] < 0){
      addX[i] = addX[i] * -1;
    }
    if(x[i] > width){
      addX[i] = addX[i] * -1;
    }
    if(y[i] < 0){
      addY[i] = addY[i] * -1;
    }
    if(y[i] > height){
      addY[i] = addY[i] * -1;
    }
  }
}
