/* 配列と繰り返しで円をたくさん描くサンプル（一つ前についていく動き） */
let x = new Array(200);   //円のx座標を入れる配列
let y = new Array(x.length);   //円のy座標を入れる配列。長さは配列xの長さと同じだけ

function setup(){
  createCanvas(windowWidth, windowHeight);
  //配列xの長さ（要素の数）ぶんだけ繰り返しを作り、各要素の値を初期化する
  for(let i = 0; i < x.length; i = i + 1){
      x[i] = width/2;  //i番目のxを、画面幅の半分にする
      y[i] = height/2;  //i番目のyを、画面高さの半分にする
  }
}
function draw(){
  background(0);
  //配列xの長さぶんだけ繰り返しを作り、その回数だけ円を描く
  for(let i = 0; i < x.length; i = i + 1){
    if(i == 0){     //最初のx,yだけマウスのx,y座標に近づける
      x[i] = x[i] + (mouseX - x[i]) / 10.0;
      y[i] = y[i] + (mouseY - y[i]) / 10.0;
    }else{          //それ以外のx,yは1つ前のx,yの値に近づける
      x[i] = x[i] + (x[i-1] - x[i]) / 10.0;
      y[i] = y[i] + (y[i-1] - y[i]) / 10.0;
    }
    noFill();
    stroke(255, 255, 0);
    circle(x[i], y[i], 100); //x, y, rを使って円を描画
  }
}
