/* 配列と繰り返しで円をたくさん描く（螺旋状に並べる） */
let kyori = new Array(400);         //画面の中心から円の中心までの距離を入れる配列
let kakudo = new Array(kyori.length);   //画面の中心に対する円の中心への角度を入れる配列。長さは配列kyoriの長さと同じだけ
let r = new Array(kyori.length);   //円の半径を入れる配列。長さは配列kyoriの長さと同じだけ
let kaiten = 0;     //全体の回転角度
function setup(){
  createCanvas(windowWidth, windowHeight);
  //配列kyoriの長さ（要素の数）ぶんだけ繰り返しを作り、各要素の値を初期化する
  for(let i = 0; i < kyori.length; i = i + 1){
      kyori[i] = i * 4;   //iに比例した距離を計算する
      kakudo[i] = 0;    //角度にはとりあえず0を入れる（draw()で改めて指定するからここでは0でもよい）
      r[i] = i * 5;   //i番目のrに、iに比例した値を代入する
  }
}
function draw(){
  background(0);
  //配列kyoriの長さぶんだけ繰り返しを作り、その回数だけ円を描く
  for(let i = 0; i < kyori.length; i = i + 1){
    let cx = width/2;   //画面の中心のx座標
    let cy = height/2;    //画面の中心のy座標
    let scale = (mouseX - width/2) / width / 2;   //マウスのx座標と画面の中心のx座標との差を取り、それを画面幅の半分で割る（画面の左端に来ると結果が-1.0、右端に来ると結果が1.0になる）
    let angle = i * 0.5 * scale + kaiten;     //iに比例した角度を計算する
    let x = cx + kyori[i] * cos(angle);  //kyori, kakudoの値から描画すべきx座標を求める
    let y = cy + kyori[i] * sin(angle);  //kyori, kakudoの値から描画すべきy座標を求める
    noFill();
    stroke(255, 255, 0);
    circle(x, y, r[i]*2); //x, y, rを使って円を描画
  }
  kaiten = kaiten + 0.001;   //全体の角度を少し増やす
}
