/* 回転角の説明のためのサンプル */
let x = 0;      //クリックで発射される玉のx座標
let y = 0;      //クリックで発射される玉のy座標
let addX = 0;      //発射される玉の移動量（x）。最初は0にしておく
let addY = 0;      //発射される玉の移動量（y）。最初は0にしておく
let r = 20;     //発射される玉の半径

let tx = 0;     //画面上にランダムに現れる標的のx座標
let ty = 0;     //画面上にランダムに現れる標的のy座標
let tr = 20;     //画面上にランダムに現れる標的の半径

function setup(){
  createCanvas(windowWidth, windowHeight);
  x = width/2;    //発射される玉の初期座標は画面の中心に
  y = height/2;
  tx = random(width);     //標的の座標をランダムで設定
  ty = random(height);
}
function draw(){
	background(0, 0, 0);

  //atan2()という関数を使い、画面の中心に対するマウスカーソルの座標への角度を取得する（目標地点のy座標-基準点のy座標、目標地点のx座標-基準点のx座標の順番で引数を入れる。先にy座標、次にx座標の順番なのに注意）
  let kakudo = atan2(mouseY - height/2, mouseX - width/2);  //-PI〜PIの間で値が返される

  //画面の中心に対するマウスの角度に応じて、円弧を描画する
  stroke(100);
  noFill();
  if(kakudo >= 0){
    arc(width/2, height/2, 200, 200, 0, kakudo);
  }else{
    arc(width/2, height/2, 200, 200, kakudo, PI*2);
  }

  //画面の中心からマウスの方向に直線を描く
  let rr = 200;
  let xx = width/2 + rr * cos(kakudo);
  let yy = height/2 + rr * sin(kakudo);
  line(width/2, height/2, xx, yy);

  //x軸、y軸の描画
  line(0, height/2, width, height/2);
  line(width/2, 0, width/2, height);

  //角度を文字として描画する
  let textR = 120;
  let textX = width/2 + textR * cos(kakudo);
  let textY = height/2 + textR * sin(kakudo);
  noStroke();
  fill(0, 255, 0);
  text(kakudo, textX, textY);

  //玉の描画
  noStroke();
  fill(255, 255, 0);
  circle(x, y, r*2);

  //玉の移動
  x = x + addX;
  y = y + addY;
  //玉が画面外に行った時は中心に戻し、移動量を0にする
  if(x < 0 || x > width || y < 0 || y > height){
    x = width/2;
    y = height/2;
    addX = 0;
    addY = 0;
  }

  //標的の描画
  noStroke();
  fill(255, 100, 0);
  circle(tx, ty, tr*2);

  //標的と玉がぶつかったら、標的をまたランダムの位置に移動する
  if(dist(x, y, tx, ty) < r + tr){
    tx = random(width);
    ty = random(height);
  }
}

function mousePressed(){
  //マウスが押されたら、画面の中心からマウスカーソルの方向に球を発射する
  let kakudo = atan2(mouseY - height/2, mouseX - width/2);    //画面の中心からマウスカーソルへの角度を取得
  x = width/2;     //位置を画面の中心に
  y = height/2;
  addX = 10 * cos(kakudo);      //角度を元にしてx移動量を決める
  addY = 10 * sin(kakudo);      //角度を元にしてy移動量を決める
}
