/* 四角形の上でマウスを押し下げる */
let x = 0;		//四角形の左上の頂点のx座標
let y = 0;		//四角形の左上の頂点のy座標
let w = 100;  //四角形の幅
let h = 100;  //四角形の高さ
let g = 0;    //背景のRGB値のGに使う変数。マウスが四角形の上で押された状態なら255に近づける。
let oshita = false;   //四角形の上でマウスを押している状態かどうかを保存する変数（押している状態ならtrueに変える）
function setup(){
  createCanvas(windowWidth, windowHeight);
  x = width/2;    //xを画面の中心に
  y = height/2;  //yを画面の中心に
}
function draw(){
	background(255, g, 0);
  noStroke();
  fill(255, 255, 0);
  //mouseXが四角形の左辺から右辺の間にあり、かつmouseYが上辺から下辺の間にある場合、四角形の幅と高さを大きくする
  if(x - w/2 < mouseX && mouseX < x + w/2 && y - h/2 < mouseY && mouseY < y + h/2){
    w = w + (300 - w) / 10.0;
    h = h + (300 - h) / 10.0;
  }else{
    w = w + (100 - w) / 10.0;
    h = h + (100 - h) / 10.0;
  }
  //四角形の上でマウスを「押している状態」なら背景のG（緑）の値を255に近づける。それ以外は0に近づける。
  if(oshita == true){
    g = g + (255 - g) / 10.0;
  }else{
    g = g + (0 - g) / 10.0;
  }
  rect(x - w/2, y - h/2, w, h);   //変数を使って四角形を描画
}
function mousePressed(){
  oshita = false;   //四角形の上でマウスを「押している状態かどうか」を一旦falseに
  //mouseXが四角形の左辺から右辺の間にあり、かつmouseYが上辺から下辺の間にある場合、「oshita」をtrueに変える
  if(x - w/2 < mouseX && mouseX < x + w/2 && y - h/2 < mouseY && mouseY < y + h/2){
    oshita = true;
  }
}
function mouseReleased(){
  oshita = false;   //マウスが離されたら、「押している状態かどうか」をfalseに戻す
}
