/* 正三角形の回転とRGBのブレンド */
let a = 0;
let b = 0;
let c = 0;
let r = 300;
function setup(){
  createCanvas(windowWidth, windowHeight);
}
function draw(){
  clear();          //背景を消去（透明に）
  blendMode(ADD);  //ブレンドモードを「加算」に
  //自作の三角形描画関数を使って三角形を描く（関数の説明は下の「function drawTriangle(...)」に書いてある）
  drawTriangle(width/2, height/2, r, a, color(255, 0, 0));    //赤
  drawTriangle(width/2, height/2, r, b, color(0, 255, 0));    //緑
  drawTriangle(width/2, height/2, r, c, color(0, 0, 255));    //青
  a = a + 0.004;    //赤い三角形の回転
  b = b + 0.008;    //緑の三角形の回転
  c = c + 0.012;    //青い三角形の回転
}
//自作の三角形描画関数。引数は中心のx, y座標、半径、1つめの点の角度、色
function drawTriangle(cx, cy, hankei, angle, col){
  //1つめの頂点のx,y座標を計算
  let x1 = cx + hankei * cos(angle);
  let y1 = cy + hankei * sin(angle);
  //2つめの頂点のx,y座標を計算（引数の角度+120度）
  let x2 = cx + hankei * cos(angle + PI * 2 / 3);
  let y2 = cy + hankei * sin(angle + PI * 2 / 3);
  //3つめの頂点のx,y座標を計算（引数の角度+240度）
  let x3 = cx + hankei * cos(angle + PI * 4 / 3);
  let y3 = cy + hankei * sin(angle + PI * 4 / 3);
  //三角形の描画開始
  beginShape();   //beginShape()からendShape()の間に頂点を追加すると、一つの多角形として描画される
  noStroke();
  fill(col);  //塗りの設定
  vertex(x1, y1);   //頂点の追加
  vertex(x2, y2);   //頂点の追加
  vertex(x3, y3);   //頂点の追加
  endShape();
}
