/* webカメラを使う（中心の幅1ピクセルだけ取得する） */
let x = 0;
let y = 0;
let capture;    //ビデオキャプチャ
function setup(){
  createCanvas(windowWidth, windowHeight);
  y = 0;
  capture = createCapture(VIDEO);   //キャプチャ開始(webカメラからの画像がcaptureオブジェクトに入る)
  capture.hide();                   //キャプチャ画面を表示しないようにする
}
function draw(){
  x += 1;   //描画するx座標をずらす
  if(capture.loadedmetadata){                //ブラウザのセキュリティ対策で必要なif文
    let img = capture.get(capture.width/2-1, 0, 1, capture.height);     //キャプチャ画面の中央、横幅1ピクセル分だけ取得する
    image(img, x, y, 1, img.height);         //取得したビットマップデータを画面上に描く
    //描画するx座標が右端まできてしまったら0に戻す
    if(x > width){
      x = 0;
    }
  }
}
