/* webカメラを使う（上から1ピクセルずつスキャンする） */
let x = 0;
let y = 0;
let capture;    //ビデオキャプチャ
function setup(){
  createCanvas(windowWidth, windowHeight);
  y = 0;
  capture = createCapture(VIDEO);   //キャプチャ開始(webカメラからの画像がcaptureオブジェクトに入る)
  capture.hide();                   //キャプチャ画面を表示しないようにする
}
function draw(){
  y += 1;   //キャプチャからスキャンするピクセルのy座標をずらす
  if(capture.loadedmetadata){                          //ブラウザのセキュリティ対策で必要なif文
    let img = capture.get(0, y, capture.width, 1);     //キャプチャ画面から幅いっぱい、高さ1ピクセルぶんのビットマップデータを取得する。その際、スキャン開始するy座標を毎フレーム1ピクセルずつずらす
    image(img, x, y, img.width, 1);                    //取得したビットマップデータを画面上に描く
    //スキャンするピクセルのy座標が下まできてしまったら0に戻す
    if(y > capture.height){
      y = 0;
    }
  }
}
