//1フレーム前のマウスの座標と現在のマウスの座標（スムーズなカーブ）
let lastMidX = 0; //1フレーム前の中点を保存しておく
let lastMidY = 0; //1フレーム前の中点を保存しておく
function setup(){
  createCanvas(windowWidth, windowHeight);
  background(0, 0, 0);
}
function draw(){
  /*
  beginShape()からendShape()の間にvertex()やquadraticVertex()で点を打つと、パスが描かれる。
  1フレーム前のマウスの座標と現在のマウスの座標との中点を取る。
  その中点を毎フレームlastMidX、lastMidYに保存する
  1フレーム前の中点、1フレーム前のマウスの座標、最新の中点の3点でカーブを描く
  */
  beginShape();
  strokeWeight(1);
  stroke(255);
  noFill();
  vertex(lastMidX, lastMidY);  //1フレーム前の中点を追加
  let midX = (pmouseX + mouseX)/2;  //1フレーム前のマウスの座標と現在のマウスの座標の中点をとる
  let midY = (pmouseY + mouseY)/2;
  quadraticVertex(pmouseX, pmouseY, midX, midY);  //カーブの点を打つ（1フレーム前のマウスの座標、最新の中点）
  endShape();
  
  lastMidX = midX;  //中点の保存
  lastMidY = midY;
}
