function setup () {
  createCanvas(windowWidth, windowHeight);
}

function draw() {
  background(0);

  //左上の図======================================
  stroke(255, 0, 0);
  noFill();
  //beginShape()からendShape()で囲った間にvertex(x, y)で頂点を打つと多角形が書ける。
  beginShape();
  vertex(150, 100);  //始点を打つ
  vertex(250, 50);  //現在の点から引数の点まで直線を引く
  vertex(350, 200);  //現在の点から引数の点まで直線を引く
  vertex(300, 300);  //現在の点から引数の点まで直線を引く
  vertex(150, 250);  //現在の点から引数の点まで直線を引く
  endShape(CLOSE);  //CLOSEだと最後の点から最初の点を結んで形態を閉じる

  //右上の図======================================
  stroke(255, 255, 0);
  noFill();
  beginShape();
  vertex(650, 100);
  vertex(750, 50);
  vertex(850, 200);
  vertex(800, 300);
  vertex(650, 250);
  endShape();  //引数に何も書かないと最後の点と最初の点を結ばず、形態を閉じない。

  //左下の図====================================
  noStroke();
  fill(50, 50, 255);
  beginShape();
  vertex(124, 520);  //始点を打つ
  bezierVertex(126, 508, 128, 488, 160, 488);  //現在の点からベジェ曲線を引く。引数は制御点1の(x,y), 制御点2(x,y), 終点(x,y)の6つ。
  bezierVertex(191, 488, 180, 474, 219, 474);
  bezierVertex(258, 474, 243, 501, 274, 501);
  bezierVertex(305, 501, 306, 489, 341, 489);
  bezierVertex(376, 489, 386, 516, 386, 525);
  bezierVertex(386, 535, 387, 610, 338, 609);
  bezierVertex(290, 609, 338, 569, 290, 569);
  bezierVertex(249, 569, 265, 634, 216, 634);
  bezierVertex(196, 634, 187, 619, 190, 599);
  bezierVertex(194, 579, 216, 565, 203, 549);
  bezierVertex(187, 529, 167, 558, 146, 558);
  bezierVertex(123, 558, 122, 532, 124, 520);
  endShape();

  //右下の図====================================
  stroke(255, 0, 255);
  noFill();
  beginShape();
  vertex(642, 453);
  bezierVertex(658, 454, 683, 446, 741, 446);
  bezierVertex(791, 446, 840, 474, 840, 502);
  bezierVertex(840, 546, 737, 559, 737, 631);
  bezierVertex(737, 678, 773, 681, 787, 681);
  bezierVertex(799, 681, 852, 675, 852, 595);
  bezierVertex(852, 546, 794, 525, 794, 471);
  bezierVertex(794, 418, 852, 445, 852, 479);
  bezierVertex(852, 511, 819, 538, 788, 532);
  bezierVertex(758, 532, 669, 519, 669, 412);
  endShape();
}
